package com.ejie.ab04b.control;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.Notificaciones;
import com.ejie.ab04b.service.NotificacionesService;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.security.UserCredentials;

/**
 * Ab0428t00Controller generated by UDA, 16-jun-2017 8:19:37.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/notificaciones")

public class NotificacionesController {

	private static final Logger logger = LoggerFactory
			.getLogger(NotificacionesController.class);

	@Autowired()
	private NotificacionesService ab0428t00Service;

	/**
	 * Usamos este mÃ©todo para indicarle a Spring el formato que debe usar para
	 * serializar las fechas cuando cargamos la entidad en el Model. En el resto
	 * de peticiones que devuelven un objeto con la anotaciÃ³n '@ResponseBody'
	 * se usan los serializadores de UDA
	 * 
	 * binder WebDataBinder
	 *
	 * @param binder
	 *            the binder
	 */
	@InitBinder()
	public void initBinder(WebDataBinder binder) {

		Locale locale = LocaleContextHolder.getLocale();
		DateFormat dateFormat = null;
		if (locale.equals(Constantes.LOCALE_ES)) {
			dateFormat = new SimpleDateFormat(Constantes.ES_DATE_MASK);
		} else {
			dateFormat = new SimpleDateFormat(Constantes.EU_DATE_MASK);
		}
		binder.registerCustomEditor(Date.class,
				new CustomDateEditor(dateFormat, true));
	}

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * idnotificacion028 Integer
	 *
	 * @param idnotificacion028
	 *            the idnotificacion 028 Ab0428t00 Objeto correspondiente al
	 *            identificador indicado.
	 * @return the notificaciones
	 */
	@RequestMapping(value = "/{idnotificacion028}", method = RequestMethod.GET)
	public @ResponseBody() Notificaciones get(
			@PathVariable() Integer idnotificacion028) {
		Notificaciones ab0428t00 = new Notificaciones();
		ab0428t00.setIdnotificacion028(idnotificacion028);
		ab0428t00 = this.ab0428t00Service.find(ab0428t00);
		NotificacionesController.logger
				.info("[GET - findBy_PK] : Obtener Ab0428t00 por PK");
		return ab0428t00;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model
	 *
	 * @param model
	 *            the model String
	 * @return the form edit
	 */
	@RequestMapping(method = RequestMethod.GET)
	public String getFormEdit(Model model) {

		model.addAttribute("autoridades",
				UtilSeguridad.getInstance().obtenerDelegacionesUsuario());

		model.addAttribute("notificacionesFiltroModel", new Notificaciones());

		NotificacionesController.logger.info("[GET - View] : ab0428t00");
		return "notificaciones";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filterAb0428t00 Notificaciones Bean que contiene los parametros de
	 * filtrado a emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado. model Model
	 * request HttpServletRequest request response HttpServletResponse
	 *
	 * @param filterAb0428t00
	 *            the filter ab 0428 t 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param model
	 *            the model
	 * @param request
	 *            the request
	 * @param response
	 *            the response JQGridResponseDto<Ab0428t00> Dto que contiene el
	 *            resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody() JQGridResponseDto<Notificaciones> filter(
			@RequestJsonBody(param = "filter") Notificaciones filterAb0428t00,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto, Model model,
			HttpServletRequest request, HttpServletResponse response) {

		setDestinatarioDeXLNets(filterAb0428t00);

		NotificacionesController.logger
				.info("[POST - filter] : Obtener Ab0428t00s");
		return this.ab0428t00Service.filter(filterAb0428t00, jqGridRequestDto,
				false);
	}

	/**
	 * Gets the notificaciones sin leer.
	 * 
	 * Long
	 *
	 * @return the notificaciones sin leer
	 */
	@RequestMapping(value = "/comprobarNuevas", method = RequestMethod.GET)
	@ResponseBody()
	public Long getNotificacionesSinLeer() {

		// filtro con DNI de usuario actual
		Notificaciones filtro = new Notificaciones();

		setDestinatarioDeXLNets(filtro);
		filtro.setLeido(0);

		return this.ab0428t00Service.findAllLikeCount(filtro);

	}

	/**
	 * Devuelve un objeto Personas con el DNI del usuario logado.
	 * 
	 * filterNotif Notificacinoes
	 *
	 * @param filterNotif
	 *            the new destinatario de XL nets
	 */
	private void setDestinatarioDeXLNets(Notificaciones filterNotif) {

		try {
			UserCredentials userCredentials = (UserCredentials) SecurityContextHolder
					.getContext().getAuthentication().getCredentials();

			List<String> perfiles = userCredentials.getUserProfiles();

			if (perfiles != null) {
				if (perfiles.contains(Constantes.ROL_TRAMITADOR_ALAVA)
						|| perfiles.contains(Constantes.ROL_TRAMITADOR_BIZKAIA)
						|| perfiles
								.contains(Constantes.ROL_TRAMITADOR_GIPUZKOA)) {
					filterNotif.setDestinatario028("RESP_TAREA");
				} else if (perfiles
						.contains(Constantes.ROL_TRAMITADOR_OSALAN_ALAVA)
						|| perfiles.contains(
								Constantes.ROL_TRAMITADOR_OSALAN_BIZKAIA)
						|| perfiles.contains(
								Constantes.ROL_TRAMITADOR_OSALAN_GIPUZKOA)) {
					filterNotif.setDestinatario028("RESP_TAREA_OSALAN");
				} else if (perfiles.contains(Constantes.ROL_ADMIN)
						|| perfiles.contains(Constantes.ROL_INSPECCION)) {
					filterNotif.setDestinatario028("RESP_INSPECTOR");
				}
			}
		} catch (Exception e) {
			filterNotif.setDestinatario028("XXXX");
		}

	}

}
